![TERROR-DRIVEN-DEVELOPMENT](./TERROR-DRIVEN-DEVELOPMENT.png)

# ***Terror***-Driven Development 🎃

Bienvenue au défi du ***Terror-Driven development*** ! L'objectif ? Écrire le code le plus terrifiant, inefficace, alambiqué et complexe pour résoudre un problème donné.

# Concept de l'*event*

Je vous mets au défi de conjurer le code le plus terrifiant et monstrueux qui soit, un code si effroyable qu'il donnerait des sueurs au plus *senior* des développeurs. Etes-vous prêt à plonger dans les ténèbres de la programmation et à ressusciter les pires cauchemars de nos profs ?

# Critères de Jugement

- **Inefficacité du Code** : Le code ne doit pas simplement fonctionner : il doit le faire d'une manière inutilement alambiquée.
- **Complexité** : Plus c'est compliqué, mieux c'est. Les solutions simples ne sont pas les bienvenues ici. Prenez tout l'espace mémoire, faites des boucles imbriquées à 15 niveaux, vérifiez plusieurs fois les mêmes choses!
- **Commentaires** : Si un morceau de code est particulièrement terrible d'une manière subtile, utilisez des commentaires pour le mettre en évidence.

Bien sûr il ne suffit pas de boucler sur des choses inutilement pour gagner... faites du code affreux oui, mais intelligemment!

# Comment Participer

1. **Forker le Projet** : Cliquez sur le bouton "Fork" en haut à droite pour créer votre propre copie de ce dépôt.
2. **Codez** : Ajoutez votre solution terrifiante dans votre fork. **Choisissez un seul sujet!**
3. **Pushez** : Poussez votre code dans votre fork **avant la date butoire**.
4. **Permissions** : Assurez-vous de m'ajouter à votre fork pour que je puisse voir et cloner votre solution **avant la date butoire**.

# Sujets au choix (en sélectionner un seul)

Choisissez le sujet en fonction de votre niveau, de votre motivation, et du temps que vous voulez accorder au défi! Rendez le choix du sujet évident (nom de fichier, précision dans le readme...)

## Niveau simple : Epouvantail stagiaire 🐣

Écrivez un script qui génère des noms de monstres aléatoires à partir de syllabes données.

## Niveau intermédiaire : Fantôme *junior* 👻

Créez un système pour représenter différents types de monstres (vampires, zombies, loups-garous, ingénieur QA...) avec leurs propriétés et méthodes spécifiques.

## Niveau expert : Mage noir *senior* 🧙

Générez un labyrinthe aléatoire où un joueur doit trouver la sortie. Chaque pièce peut avoir des monstres, des trésors ou des pièges.

# Règles

- **Dates** : Le défi commence le 30 octobre et se termine le 5 novembre à 23h. **Tous vos forks seront alors automatiquement clonés, attention à rendre vos solutions à temps et à m'ajouter à votre dépôt en tant que *Reporter*!**
- **Langages Autorisés** : C, Python, Java, Javascript.
- **Intégrité du Code** : Le code ne doit pas être obfusqué ou minifié. Son horreur doit découler de sa conception, de sa logique, de sa  structure, etc.
- **Commentaires** : Ajoutez des commentaires pour mettre en évidence les parties particulièrement mauvaises du code.
- **Fichiers Supplémentaires** : Seul le code sera évalué. Les tests ou fichiers de configuration ne seront pas pris en compte. Le code doit être syntaxiquement correct et compiler (pour les langages pertinents).

# Échelle de scores

Selon votre sujet, un multiplicateur raisonnable sera appliqué sur votre score final.

Les points seront accordés selon une échelle 100% rigoureuse et basée sur les sciences occultes.

| **Score** | **Distinction horrifique** |
|-----------|----------------------------|
| 40 - 50   | Invocation de Cthulhu 🦑   |
| 30 - 39   | Évocation de Ça 🤡         |
| 20 - 29   | Éveil de Dracula 🧛        |
| 10 - 19   | Tour de  Skellington 🎃    |
| 0 - 9     | Farce de Casper 👻         |

# Exemple

```bash
Problème : Implémenter une fonction en Python qui détermine si un entier est pair.
```

**Une solution glaçante** :

```python
import random

# On va bien sûr créer deux classes, parce que je ne peux pas résoudre un problème si complexe 
# sans réifier les concepts qu'il implique
class Number:
    def __init__(self, value):
        self.value = value
        self.is_even = None

    def determine_evenness(self, key):
        calculator = EvennessCalculator(self)
        self.is_even = calculator.calculate()

class EvennessCalculator:
    def __init__(self, number):
        self.number = number

    def calculate(self):
        # On va utiliser deux méthodes différentes en même temps, comme ça on est doublement sûrs.
        result1 = self._method1()
        result2 = self._method2()

        while result1 != result2:  # Doublement sûr
            # Les deux méthodes ne renvoient pas la même chose? Peut-être que la prochaine fois, ça sera bon
            result2 = self._method2()
        return result1 and result2  # Même triplement sûr

    def _method1(self):
        value_copy = self.number.value
        if value_copy < 0:
            while value_copy < 0:
                value_copy += 2
        while value_copy > 0:
            value_copy -= 2
        return value_copy == 0

    def _method2(self):
        # Après tout, pour n'importe quel chiffre, on a une chance sur 2 qu'il soit pair, non?
        return random.choice([True, False]) 

def est_pair(n):
    number = Number(n)
    number.determine_evenness()
    return number.is_even

# Si c'est stupide mais que ça marche, est ce que c'est toujours stupide?
```

Que le pire code gagne et... Malchance à vous ! 👻🎃🔮
